/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cross_language;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-jumbled-for-loop-modifications", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.CS, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.PHP, ELanguage.SWIFT, ELanguage.GROOVY, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.GO}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidJumbledLoopModificationsCheck
extends CheckImplementationBase {
    private static final String FINDINGS_MESSAGE = "Avoid jumbled loop modifications (jumbled variable: {0})";
    private static final ITokenMatcher ASSIGNMENT_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ, ETokenType.URSHIFTEQ});

    public void execute() throws CheckException {
        List statementsInForLoop = ShallowEntityTraversalUtils.findNestedEntities((List)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT), statement -> "for".equals(statement.getSubtype()), EnumSet.of(EShallowEntityType.STATEMENT));
        for (ShallowEntity statementInForLoop : statementsInForLoop) {
            if (!"for".equals(statementInForLoop.getSubtype())) continue;
            this.processEntity(statementInForLoop);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.count((List)tokens, (ETokenType)ETokenType.SEMICOLON) != 2) {
            return;
        }
        Set<String> parentLoopVariables = this.getParentLoopVariables(entity);
        Set<String> conditionVariables = AvoidJumbledLoopModificationsCheck.extractAllVariablesFromCondition((List<IToken>)tokens);
        Set<String> stepVariables = AvoidJumbledLoopModificationsCheck.extractStepVariables((List<IToken>)tokens);
        parentLoopVariables.retainAll(stepVariables);
        for (String variable : parentLoopVariables) {
            if (conditionVariables.contains(variable)) continue;
            this.buildFinding(MessageFormat.format(FINDINGS_MESSAGE, variable), this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }

    private Set<String> getParentLoopVariables(ShallowEntity entity) {
        ShallowEntity parentEntity = entity.getParent();
        HashSet<String> variables = new HashSet<String>();
        while (parentEntity.getType() == EShallowEntityType.STATEMENT) {
            UnmodifiableList parentTokens = parentEntity.ownStartTokens();
            if (parentEntity.getSubtype().equals("for") && TokenStreamUtils.count((List)parentTokens, (ETokenType)ETokenType.SEMICOLON) == 2) {
                variables.addAll(this.extractDefinedVariables((List<IToken>)parentTokens));
            }
            parentEntity = parentEntity.getParent();
        }
        return variables;
    }

    private Set<String> extractDefinedVariables(List<IToken> tokens) {
        int endInitializations = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.SEMICOLON);
        List assignments = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)endInitializations, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, this.getLoopVariableAssignmentOperator()});
        return AvoidJumbledLoopModificationsCheck.getTextsOfIdentifiers(tokens, assignments);
    }

    private static Set<String> extractAllVariablesFromCondition(List<IToken> tokens) {
        int startIndexCondition = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.SEMICOLON);
        int endIndexCondition = TokenStreamUtils.firstTokenMatching(tokens, (int)(startIndexCondition + 1), (ITokenMatcher)ETokenType.SEMICOLON);
        List variableIndices = TokenStreamUtils.findAll(tokens, (int)startIndexCondition, (int)endIndexCondition, (ITokenMatcher)ETokenType.IDENTIFIER);
        return AvoidJumbledLoopModificationsCheck.getTextsOfIdentifiers(tokens, variableIndices);
    }

    private ETokenType getLoopVariableAssignmentOperator() {
        if (this.context.getLanguage() == ELanguage.GO) {
            return ETokenType.COLON_EQ;
        }
        return ETokenType.EQ;
    }

    private static Set<String> extractStepVariables(List<IToken> tokens) {
        int startStepAssignment = TokenStreamUtils.lastTokenMatching(tokens, (ITokenMatcher)ETokenType.SEMICOLON);
        ArrayList<Integer> assignments = new ArrayList<Integer>();
        assignments.addAll(AvoidJumbledLoopModificationsCheck.getVariableIndicesFromAssignments(tokens, startStepAssignment));
        assignments.addAll(AvoidJumbledLoopModificationsCheck.getVariableIndicesFromPostAndPrefixOperators(tokens, startStepAssignment));
        return AvoidJumbledLoopModificationsCheck.getTextsOfIdentifiers(tokens, assignments);
    }

    private static List<Integer> getVariableIndicesFromAssignments(List<IToken> tokens, int startIndex) {
        return TokenStreamUtils.findAll(tokens, (int)startIndex, (int)(tokens.size() - 1), (ITokenMatcher)ASSIGNMENT_OPERATORS).stream().map(i -> i - 1).toList();
    }

    private static List<Integer> getVariableIndicesFromPostAndPrefixOperators(List<IToken> tokens, int startIndex) {
        List inAndDecrementIndices = TokenStreamUtils.findAll(tokens, (int)startIndex, (int)(tokens.size() - 1), (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUSPLUS, ETokenType.MINUSMINUS}));
        return inAndDecrementIndices.stream().map(index -> AvoidJumbledLoopModificationsCheck.getIdentifierForUnaryOperatorIndex(index, tokens)).toList();
    }

    private static int getIdentifierForUnaryOperatorIndex(int operatorIndex, List<IToken> tokens) {
        if (operatorIndex - 1 >= 0 && tokens.get(operatorIndex - 1).getType().isIdentifier()) {
            return operatorIndex - 1;
        }
        return operatorIndex + 1;
    }

    private static Set<String> getTextsOfIdentifiers(List<IToken> tokens, List<Integer> indices) {
        HashSet<String> variables = new HashSet<String>();
        for (int index : indices) {
            variables.add(tokens.get(index).getText());
        }
        return variables;
    }
}

