/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-remove-empty-finalizers", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class RemoveEmptyFinalizersCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            for (ShallowEntity child : type.getChildren()) {
                if (child.getType() != EShallowEntityType.METHOD || !child.getSubtype().equals("destructor")) continue;
                this.processEntity(child);
            }
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (!entity.hasChildren()) {
            this.buildFinding("Empty finalizer for `" + entity.getName() + "` should be removed", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

