/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.base.AvoidStringFormatInLogStatementsBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-java-avoid-string-format-in-log-statement", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaAvoidStringFormatInLogStatementCheck
extends AvoidStringFormatInLogStatementsBase {
    private static final String FINDING_MESSAGE_STRING_FORMAT = "Avoid using String.format or *.format in log statements";
    private static final String FINDING_MESSAGE_STRING_FORMATTING = "Avoid using String formatting in log statements";
    private static final String FORMAT_METHOD_NAME = "format";

    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList entityTokens = entity.includedTokens();
        IToken lastToken = (IToken)entityTokens.get(0);
        for (IToken currentToken : entityTokens) {
            ETokenType currentTokenType = currentToken.getType();
            if (currentTokenType == ETokenType.ARROW) {
                return;
            }
            if (lastToken.getType() == ETokenType.DOT && currentToken.getText().contains(FORMAT_METHOD_NAME)) {
                this.buildFinding(FINDING_MESSAGE_STRING_FORMAT, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            }
            if (currentTokenType == ETokenType.PLUS) {
                this.buildFinding(FINDING_MESSAGE_STRING_FORMATTING, this.buildLocation().forEntityFirstLine(entity)).createAndStore();
            }
            lastToken = currentToken;
        }
    }
}

