/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Check(id="cqse-unnecessary-big-integer-instantiation", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class UnnecessaryBigIntegerInstantiationCheck
extends CheckImplementationBase {
    private static final Map<String, String> RAW_VALUES_TO_STRING_VERSION = Map.ofEntries(Map.entry("0", "ZERO"), Map.entry("1", "ONE"), Map.entry("10", "TEN"));
    private static final JavaMethodCallMatcher BIG_INTEGER_CONSTRUCTOR_MATCHER = JavaMethodCallMatcher.create().onTypes(new String[]{"java.math.BigInteger", "java.math.BigDecimal"}).constructors().withParameterCount(1);

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall methodCall : BIG_INTEGER_CONSTRUCTOR_MATCHER.find(this.context, typeResolver)) {
            Optional<String> replacement = UnnecessaryBigIntegerInstantiationCheck.cleanConstructorArgument((List)methodCall.parameters().getFirst());
            if (!replacement.isPresent()) continue;
            this.buildFinding("Use `" + methodCall.methodName() + "." + replacement.get() + "` instead of creating new object", this.buildLocation().betweenTokens(methodCall.token(), (IToken)((List)methodCall.parameters().getFirst()).getFirst())).createAndStore();
        }
    }

    private static Optional<String> cleanConstructorArgument(List<IToken> argumentTokens) {
        if (argumentTokens.size() > 1) {
            return Optional.empty();
        }
        String replacement = RAW_VALUES_TO_STRING_VERSION.get(argumentTokens.getFirst().getText().replaceAll("\"|\\.0+", ""));
        return Optional.ofNullable(replacement);
    }
}

