/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;

@Check(id="java:S1941", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class VariableDeclarationScopeCheck
extends CheckImplementationBase {
    private static final Set<String> COMPOUND_STATEMENT_SUBTYPES = Set.of("if", "for", "while", "do", "try", "catch", "switch", "synchronized", "lambda", "block");
    private static final int MATCH_GROUP = 0;
    private static final TokenPattern POTENTIAL_USAGE_PATTERN = TokenPattern.of().notPrecededBy((Object)ETokenType.DOT).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);

    public void execute() throws CheckException {
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD).forEach(method -> this.analyzeBlock((List<ShallowEntity>)method.getChildren()));
    }

    private void analyzeBlock(List<ShallowEntity> statements) {
        if (statements.isEmpty()) {
            return;
        }
        IntStream.range(0, statements.size()).forEach(i -> this.analyzeMovingWindow(statements, i));
    }

    private void analyzeMovingWindow(List<ShallowEntity> statements, int i) {
        ShallowEntity currentStatement = statements.get(i);
        if (currentStatement.getType() == EShallowEntityType.STATEMENT && "local variable".equals(currentStatement.getSubtype())) {
            this.processVariableDeclaration(currentStatement, statements.subList(i + 1, statements.size()));
        }
        if (COMPOUND_STATEMENT_SUBTYPES.contains(currentStatement.getSubtype())) {
            this.analyzeBlock((List<ShallowEntity>)currentStatement.getChildren());
        }
    }

    private void processVariableDeclaration(ShallowEntity declaration, List<ShallowEntity> subsequentStatements) {
        LanguageFeatureParser.JAVA.getVariableNamesFromTokens((List)declaration.ownStartTokens()).stream().map(IToken::getText).filter(variableName -> VariableDeclarationScopeCheck.isViolation(declaration, variableName, subsequentStatements)).findFirst().ifPresent(violatedVariableName -> this.reportFinding(declaration, (String)violatedVariableName));
    }

    private static boolean isViolation(ShallowEntity declaration, String variableName, List<ShallowEntity> statements) {
        OptionalInt earliestUsageLine = VariableDeclarationScopeCheck.findFirstMatchingLineOfScope(declaration.getParent(), statements, entity -> VariableDeclarationScopeCheck.isVariableUsedIn(entity, variableName));
        if (earliestUsageLine.isEmpty()) {
            return false;
        }
        OptionalInt earliestBreakingLine = VariableDeclarationScopeCheck.findFirstMatchingLineOfScope(declaration.getParent(), statements, VariableDeclarationScopeCheck::isBreakingStatement);
        if (earliestBreakingLine.isEmpty()) {
            return false;
        }
        return earliestBreakingLine.getAsInt() < earliestUsageLine.getAsInt();
    }

    private static boolean isVariableUsedIn(ShallowEntity entity, String variableName) {
        return POTENTIAL_USAGE_PATTERN.findNonOverlappingMatches((List)entity.ownStartTokens()).stream().anyMatch(match -> match.groupString(0).equals(variableName));
    }

    private static OptionalInt findFirstMatchingLineOfScope(@Nullable ShallowEntity parent, List<ShallowEntity> statements, Predicate<ShallowEntity> predicate) {
        return ShallowEntityTraversalUtils.getAllEntities(statements).stream().filter(predicate).map(entity -> VariableDeclarationScopeCheck.getEffectiveScopeRoot(entity, parent)).mapToInt(ShallowEntity::getStartLine).findFirst();
    }

    private static ShallowEntity getEffectiveScopeRoot(ShallowEntity entity, @Nullable ShallowEntity scopeBoundary) {
        ShallowEntity topmostEntity = entity;
        for (ShallowEntity currentParent = entity.getParent(); currentParent != null && !Objects.equals(scopeBoundary, currentParent); currentParent = currentParent.getParent()) {
            topmostEntity = currentParent;
        }
        if (topmostEntity.getSubtype().equals("catch") || topmostEntity.getSubtype().equals("finally")) {
            ShallowEntity currentSibling = topmostEntity;
            while (currentSibling != null) {
                if (currentSibling.getSubtype().equals("try")) {
                    return currentSibling;
                }
                currentSibling = ShallowEntityTraversalUtils.getPreviousSiblingEntity((ShallowEntity)currentSibling);
            }
        }
        return topmostEntity;
    }

    private static boolean isBreakingStatement(ShallowEntity statement) {
        boolean isSimpleStatement;
        boolean isStatement = statement.getType() == EShallowEntityType.STATEMENT;
        boolean bl = isSimpleStatement = isStatement && "simple statement".equals(statement.getSubtype());
        if (isSimpleStatement) {
            String name = statement.getName();
            return "return".equals(name) || "throw".equals(name);
        }
        return false;
    }

    private void reportFinding(ShallowEntity declaration, String variableName) {
        String message = "Move the declaration of \"" + variableName + "\" closer to the code that uses it";
        this.buildFinding(message, this.buildLocation().forEntity(declaration)).createAndStore();
    }
}

