/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.List;

@Check(id="java:S6831", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidQualifierOnBeanMethodsCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Remove this redundant `@Qualifier` annotation and rely on the `@Bean` method";

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).stream().filter(SpringChecksUtils::isBeanMethod).flatMap(method -> LanguageFeatureParser.JAVA.getAnnotations(method).stream()).filter(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SpringChecksUtils.QUALIFIER_ANNOTATIONS)).map(annotation -> this.buildFinding(MESSAGE, this.buildLocation().forEntity(annotation))).forEach(CheckFindingBuilderBase::createAndStore);
    }
}

