/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.JavaStringValueResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.spring.SpringChecksUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="java:S6804", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ValueAnnotationShouldInjectPropertyOrSpELCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Either replace the `@Value` annotation with a standard field initialization, use `${propertyName}` to inject a property or use `#{expression}` to evaluate a SpEL expression";
    private JavaStringValueResolver javaStringValueResolver;

    public void execute() throws CheckException {
        this.javaStringValueResolver = new JavaStringValueResolver(this.context.getRootEntity(this.getCodeViewOption()));
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes((Collection)ast, Set.of(EShallowEntityType.TYPE), Set.of("@interface")).forEach(this::checkEntityForValueAnnotations);
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.ATTRIBUTE).forEach(this::checkEntityForValueAnnotations);
    }

    private void checkEntityForValueAnnotations(ShallowEntity entity) {
        LanguageFeatureParser.JAVA.getAnnotations(entity).stream().filter(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SpringChecksUtils.VALUE_ANNOTATIONS)).forEach(this::checkValueAnnotationForInvalidParameters);
    }

    private void checkValueAnnotationForInvalidParameters(ShallowEntity valueAnnotation) {
        boolean annotationHasInvalidParameter = TokenStreamUtils.split((List)LanguageFeatureParser.JAVA.getAnnotationParameterTokens(valueAnnotation), (ETokenType[])new ETokenType[]{ETokenType.COMMA}).stream().anyMatch(this::isAnnotationParameterInvalid);
        if (annotationHasInvalidParameter) {
            this.buildFinding(MESSAGE, this.buildLocation().forEntity(valueAnnotation)).createAndStore();
        }
    }

    private boolean isAnnotationParameterInvalid(List<IToken> annotationParameter) {
        List parameterValue = LanguageFeatureParser.JAVA.extractAnnotationParameterValue(annotationParameter);
        if (parameterValue.isEmpty()) {
            return false;
        }
        return this.javaStringValueResolver.resolveStringExpression(parameterValue).filter(ValueAnnotationShouldInjectPropertyOrSpELCheck::valueIsInvalid).isPresent();
    }

    private static boolean valueIsInvalid(String string) {
        return !ValueAnnotationShouldInjectPropertyOrSpELCheck.isPropertyName(string) && !ValueAnnotationShouldInjectPropertyOrSpELCheck.isSpEL(string) && !ValueAnnotationShouldInjectPropertyOrSpELCheck.referenceResource(string);
    }

    private static boolean isPropertyName(String value) {
        return value.startsWith("${") && value.endsWith("}");
    }

    private static boolean isSpEL(String value) {
        return value.startsWith("#{") && value.endsWith("}");
    }

    private static boolean referenceResource(String value) {
        return value.startsWith("classpath:") || value.startsWith("file:") || value.startsWith("url:");
    }
}

