/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-missing-f-string-prefix", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class MissingFStringPrefixCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Missing f-String prefix";
    private static final char OPENING_BRACE = '{';
    private static final char CLOSING_BRACE = '}';
    private static final int NO_OPENING_BRACE = -1;
    private static final int STRING_LITERAL_GROUP_INDEX = 0;
    private static final Set<String> F_STRING_PREFIXES = Set.of("f", "rf");
    private static final String STRING_FORMAT_IDENTIFIER_NAME = "format";
    private static final TokenPattern STRING_FORMAT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.STRING_LITERAL}).group(0).repeated(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.STRING_LITERAL, ETokenType.PLUS, ETokenType.RPAREN})}).sequence(new Object[]{ETokenType.DOT}).regex("format");
    private static final String SELF_REFERENCE_WORD = "self";
    private static final int SELF_REFERENCE_GROUP_INDEX = 1;
    private static final TokenPattern SELF_REFERENCE_CALL_PATTERN = new TokenPattern().regex("self").group(1).repeatedAtLeastOnce(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true)}).group(1);
    private final SetMap<ShallowEntity, String> declaredIdentifierNamesByEntity = new SetMap();
    private Set<String> declaredIdentifiersInCurrentScope;

    public void execute() throws CheckException {
        this.declaredIdentifierNamesByEntity.clear();
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List entities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)ast, Set.of(EShallowEntityType.TYPE, EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE, EShallowEntityType.STATEMENT));
        for (ShallowEntity entity : entities) {
            this.declaredIdentifierNamesByEntity.addAll((Object)entity, MissingFStringPrefixCheck.variableNamesForEntityScope(entity));
            this.declaredIdentifierNamesByEntity.addAll((Object)entity.getParent(), MissingFStringPrefixCheck.variableNamesForParentScope(entity));
        }
        entities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)ast, Set.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity entity : entities) {
            this.processEntity(entity);
        }
    }

    private static Set<String> variableNamesForEntityScope(@NonNull ShallowEntity entity) {
        switch (entity.getType()) {
            case TYPE: {
                String className = Objects.requireNonNull(entity.getName(), "class name must not be null");
                return Set.of(className);
            }
            case METHOD: {
                return MissingFStringPrefixCheck.declaredVariableNamesForEntity(entity);
            }
        }
        return CollectionUtils.emptySet();
    }

    private static Set<String> declaredVariableNamesForEntity(@NonNull ShallowEntity entity) {
        List tokens = LanguageFeatureParser.PYTHON.getDeclaredVariableNames(entity);
        return tokens.stream().map(IToken::getText).collect(Collectors.toSet());
    }

    private static Set<String> variableNamesForParentScope(@NonNull ShallowEntity entity) {
        switch (entity.getType()) {
            case TYPE: {
                return CollectionUtils.emptySet();
            }
            case METHOD: {
                String methodName = entity.getName();
                if (methodName == null) break;
                return Set.of(methodName);
            }
        }
        return MissingFStringPrefixCheck.declaredVariableNamesForEntity(entity);
    }

    private void processEntity(@NonNull ShallowEntity entity) {
        this.declaredIdentifiersInCurrentScope = this.getDeclaredIdentifiersInScopeOfEntity(entity);
        this.processTokens((List<IToken>)entity.ownStartTokens());
        if (entity.hasChildren()) {
            this.processTokens((List<IToken>)entity.ownEndTokens());
        }
    }

    private Set<String> getDeclaredIdentifiersInScopeOfEntity(@NonNull ShallowEntity scopeEntity) {
        HashSet<String> identifiers = new HashSet<String>();
        for (ShallowEntity entity = scopeEntity; entity != null; entity = entity.getParent()) {
            Set identifiersFromEntity = (Set)this.declaredIdentifierNamesByEntity.getCollection((Object)entity);
            if (identifiersFromEntity == null) continue;
            identifiers.addAll(identifiersFromEntity);
        }
        return identifiers;
    }

    private void processTokens(@NonNull List<IToken> tokens) {
        List stringLiterals = tokens.stream().filter(token -> token.getType() == ETokenType.STRING_LITERAL && F_STRING_PREFIXES.stream().noneMatch(prefix -> token.getText().toLowerCase().startsWith((String)prefix))).collect(Collectors.toList());
        List<IToken> stringFormats = MissingFStringPrefixCheck.stringLiteralsFromPatternMatch(STRING_FORMAT_PATTERN, tokens);
        stringLiterals.removeAll(stringFormats);
        for (IToken stringLiteral : stringLiterals) {
            this.analyseStringToken(stringLiteral);
        }
    }

    private static List<IToken> stringLiteralsFromPatternMatch(@NonNull TokenPattern tokenPattern, @NonNull List<IToken> tokens) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (TokenPatternMatch match : tokenPattern.findAll(tokens)) {
            result.addAll(match.groupTokens(0));
        }
        return result;
    }

    private void analyseStringToken(@NonNull IToken token) {
        if (this.isPotentiallyFString(token)) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forToken(token)).createAndStore();
        }
    }

    private boolean isPotentiallyFString(@NonNull IToken token) {
        List<String> expressions = MissingFStringPrefixCheck.extractFStringExpressions(token.getText());
        if (expressions.isEmpty()) {
            return false;
        }
        return expressions.stream().allMatch(this::isValidFStringExpression);
    }

    private static List<String> extractFStringExpressions(@NonNull String stringContent) {
        ArrayList<String> expressions = new ArrayList<String>();
        int openingBraceIndex = -1;
        for (int i = 0; i < stringContent.length(); ++i) {
            char currentChar = stringContent.charAt(i);
            if (currentChar == '{') {
                openingBraceIndex = i;
                continue;
            }
            if (currentChar != '}' || openingBraceIndex == -1) continue;
            String expression = stringContent.substring(openingBraceIndex + 1, i);
            expressions.add(expression);
            openingBraceIndex = -1;
        }
        return expressions;
    }

    private boolean isValidFStringExpression(@NonNull String expression) {
        List tokens = ScannerUtils.getTokens((String)expression, (ELanguage)ELanguage.PYTHON, (String)this.context.getUniformPath());
        List<IToken> identifiers = tokens.stream().filter(token -> token.getType().isIdentifier()).toList();
        if (identifiers.isEmpty()) {
            return false;
        }
        Set<IToken> instanceVariableCalls = MissingFStringPrefixCheck.extractInstanceVariableCalls(tokens);
        Set<IToken> builtInFunctionCalls = MissingFStringPrefixCheck.extractBuiltInFunctionCalls(tokens);
        for (IToken identifier : identifiers) {
            String name = identifier.getText();
            boolean isDeclaredIdentifier = this.declaredIdentifiersInCurrentScope.contains(name);
            boolean isBuiltInName = builtInFunctionCalls.contains(identifier);
            boolean isPartOfInstanceVariableCall = instanceVariableCalls.contains(identifier);
            boolean isValid = isDeclaredIdentifier || isBuiltInName || isPartOfInstanceVariableCall;
            if (isValid) continue;
            return false;
        }
        return true;
    }

    private static Set<IToken> extractBuiltInFunctionCalls(List<IToken> tokens) {
        HashSet<IToken> builtInCalls = new HashSet<IToken>();
        for (int i = 0; i < tokens.size() - 1; ++i) {
            IToken token = tokens.get(i);
            if (!LanguageFeatureParser.PYTHON.isBuiltInName(token.getText()) || tokens.get(i + 1).getType() != ETokenType.LPAREN) continue;
            builtInCalls.add(token);
        }
        return builtInCalls;
    }

    private static Set<IToken> extractInstanceVariableCalls(List<IToken> tokens) {
        HashSet<IToken> instanceVariableCallTokens = new HashSet<IToken>();
        for (TokenPatternMatch match : SELF_REFERENCE_CALL_PATTERN.findAll(tokens)) {
            List groupTokens = match.groupTokens(1);
            instanceVariableCallTokens.addAll(groupTokens);
        }
        return instanceVariableCallTokens;
    }
}

