/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.matlab.SimulinkMatlabCheckUtils;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.himl_0010", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkLogicalOperatorsAndFunctionsInCodeCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Logical operator or function operates on numerical data type %s in line %d";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Type-cast the operands to a logical data type.");
    private static final Set<String> LOGICAL_OPERATORS = Set.of("&&", "||", "~", "&", "|");
    private static final Set<String> LOGICAL_FUNCTIONS = Set.of("and", "or", "not", "xor", "all", "any", "find", "isLogical", "logical", "true", "false");

    public void execute() {
        QualifiedNameLocation location;
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedTypes == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkMatlabCheckUtils.listMatlabFunctionBlocks(model)) {
            location = this.context.buildLocation().forSimulinkBlock(block);
            for (MatlabActionTypeResolver methodBody : SimulinkMatlabCheckUtils.parseMethodsInMatlabFunctionBlockAndLogParseErrors(block, resolvedTypes, dataDictionaries, location.getQualifiedName())) {
                this.checkMethodBody(methodBody, location);
            }
        }
        for (StateflowState matlabFunctionState : StateflowUtils.getStateflowMatlabFunctions((SimulinkModel)model)) {
            location = this.context.buildLocation().forStateflowNode((StateflowNodeBase)matlabFunctionState);
            for (MatlabActionTypeResolver methodBody : SimulinkMatlabCheckUtils.parseMethodsInMatlabFunctionStateAndLogParseErrors(matlabFunctionState, resolvedTypes, dataDictionaries, location.getQualifiedName())) {
                this.checkMethodBody(methodBody, location);
            }
        }
    }

    private void checkMethodBody(MatlabActionTypeResolver typeResolver, QualifiedNameLocation location) {
        for (MatlabActionAstNode logicalNode : SimulinkLogicalOperatorsAndFunctionsInCodeCheck.listLogicalNodes(typeResolver.getRootNode())) {
            MatlabActionAstNode secondNode;
            String secondType;
            MatlabActionAstNode firstNode = (MatlabActionAstNode)logicalNode.getChildren().get(0);
            String firstType = typeResolver.inferDataTypeOf(firstNode);
            if (SimulinkLogicalOperatorsAndFunctionsInCodeCheck.isNumericalDataType(firstType)) {
                this.createFinding(firstNode, firstType, location);
            }
            if (logicalNode.getChildren().size() == 1 || !SimulinkLogicalOperatorsAndFunctionsInCodeCheck.isNumericalDataType(secondType = typeResolver.inferDataTypeOf(secondNode = (MatlabActionAstNode)logicalNode.getChildren().get(1)))) continue;
            this.createFinding(secondNode, secondType, location);
        }
    }

    private void createFinding(MatlabActionAstNode node, String type, QualifiedNameLocation location) {
        String findingMessage = String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)type), MatlabActionAstUtils.getLineNumberForAstNode((MatlabActionAstNode)node));
        this.buildFinding(findingMessage, (ElementLocation)location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    private static List<MatlabActionAstNode> listLogicalNodes(MatlabActionAstNode rootNode) {
        LinkedList<MatlabActionAstNode> logicalNodes = new LinkedList<MatlabActionAstNode>();
        SimulinkLogicalOperatorsAndFunctionsInCodeCheck.listLogicalNodesRecursively(rootNode, logicalNodes);
        return logicalNodes;
    }

    private static void listLogicalNodesRecursively(MatlabActionAstNode node, List<MatlabActionAstNode> logicalNodes) {
        if (SimulinkLogicalOperatorsAndFunctionsInCodeCheck.isLogicalOperator(node) || SimulinkLogicalOperatorsAndFunctionsInCodeCheck.isLogicalFunction(node)) {
            logicalNodes.add(node);
        }
        node.getChildren().forEach(child -> SimulinkLogicalOperatorsAndFunctionsInCodeCheck.listLogicalNodesRecursively(child, logicalNodes));
    }

    private static boolean isLogicalOperator(MatlabActionAstNode node) {
        return EMatlabActionEntityType.BOOL_OPERATION == node.getType() && node.getTokens().stream().anyMatch(token -> LOGICAL_OPERATORS.contains(token.getText()));
    }

    private static boolean isLogicalFunction(MatlabActionAstNode node) {
        return EMatlabActionEntityType.FUNCTION == node.getType() && node.getTokens().stream().anyMatch(token -> LOGICAL_FUNCTIONS.contains(token.getText()));
    }

    private static boolean isNumericalDataType(String dataType) {
        return !"boolean".equals(dataType) && !"Unknown".equals(dataType);
    }
}

