/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.hism.hisl_0012", languages={ELanguage.SIMULINK})
public class SimulinkConditionallyExecutedSubsystemCheck
extends CheckImplementationBase {
    @CheckOption(name="Check for non-inherited sample times (hisl_0012_a)", description="If set, conditionally executed subsystems are scanned for blocks without inherited sample time.")
    private boolean checkForInheritedSampleTimes = true;
    @CheckOption(name="Check for sample time-dependent blocks in asynchronously called subsystems (hisl_0012_b)", description="If set, asynchronously called subsystems are scanned for sample time-dependent blocks.")
    private boolean checkAsynchronousSubsystems = true;
    private static final Set<String> BLOCKTYPES_IGNORED_FOR_SAMPLE_TIME_CHECK = Set.of("Constant", "EnablePort", "TriggerPort");
    private static final String FINDING_MESSAGE_INHERITED_SAMPLE_TIME = "Non-inherited sample time used in block %s in conditionally executed subsystem";
    private static final String FINDING_MESSAGE_ASYNCHRONOUS = "Sample time-dependent block %s in asynchronously called subsystem";
    private static final FindingPropertyList RECOMMENDED_ACTION_INHERITED_SAMPLE_TIME = FindingPropertyList.singleton((String)"Recommended Action", (String)"All sample times shall be set to -1 (inherited)");
    private static final FindingPropertyList RECOMMENDED_ACTION_ASYNCHRONOUS = FindingPropertyList.singleton((String)"Recommended Action", (String)"Sample time-dependent blocks shall not be used in asynchronously called subsystems");
    private static final Set<String> TIME_DEPENDENT_TYPES_AND_SOURCE_TYPES = Set.of("DiscreteStateSpace", "DiscreteIntegrator", "Integrator", "DiscreteFilter", "DiscreteTransferFcn", "ZeroPole", "TransferFcn", "DiscreteZeroPole", "DiscreteFir", "First Order Transfer Fcn", "Transfer Fcn Real Zero", "Lead or Lag Compensator", "Discrete Transfer Function with Initial Outputs", "Discrete Transfer Function with Initial States", "Discrete Zero-Pole with Initial States", "Discrete Zero-Pole with Initial Outputs", "Discrete Derivative");

    public void execute() {
        if (!this.checkForInheritedSampleTimes && !this.checkAsynchronousSubsystems) {
            return;
        }
        Optional model = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (model.isEmpty()) {
            return;
        }
        for (SimulinkBlock subsystemBlock : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)((SimulinkBlock)model.get()), Set.of("SubSystem"), (boolean)false, (boolean)false)) {
            this.checkSubsystem(subsystemBlock);
        }
        this.context.getSimulinkContext().getSimulinkModelForModelFile().ifPresent(this::checkSubsystem);
    }

    private void checkSubsystem(SimulinkBlock system) {
        boolean isConditionalSubsystem = SimulinkUtils.isConditionalSubsystem((SimulinkBlock)system);
        boolean isAsyncCalled = SimulinkConditionallyExecutedSubsystemCheck.isAsynchronouslyCalledSubsystem(system);
        for (SimulinkBlock block : system.getSubBlocks()) {
            if (this.checkForInheritedSampleTimes && isConditionalSubsystem && !BLOCKTYPES_IGNORED_FOR_SAMPLE_TIME_CHECK.contains(block.getType())) {
                this.checkIfSampleTimeIsInherited(block);
            }
            if (!this.checkAsynchronousSubsystems || !isAsyncCalled) continue;
            this.checkIfBlockIsSampleTimeDependent(block);
        }
    }

    private void checkIfSampleTimeIsInherited(SimulinkBlock block) {
        String sampleTime = block.getParameter("SampleTime");
        if (sampleTime != null && !"-1".equals(sampleTime)) {
            this.buildFinding(String.format(FINDING_MESSAGE_INHERITED_SAMPLE_TIME, MarkupUtils.formatAsSourceCode((String)block.getNamePretty())), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_INHERITED_SAMPLE_TIME).createAndStore();
        }
    }

    private void checkIfBlockIsSampleTimeDependent(SimulinkBlock block) {
        String typeOrSourceType = SimulinkUtils.getTypeOrSourceType((SimulinkBlock)block);
        if (typeOrSourceType != null && TIME_DEPENDENT_TYPES_AND_SOURCE_TYPES.contains(typeOrSourceType)) {
            this.buildFinding(String.format(FINDING_MESSAGE_ASYNCHRONOUS, MarkupUtils.formatAsSourceCode((String)block.getNamePretty())), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_ASYNCHRONOUS).createAndStore();
        }
    }

    private static boolean isAsynchronouslyCalledSubsystem(SimulinkBlock block) {
        if (!block.isOfType("SubSystem")) {
            return false;
        }
        for (SimulinkBlock subBlock : block.getSubBlocks()) {
            if (!SimulinkConditionallyExecutedSubsystemCheck.isTriggeredFunctionCallSubsystem(subBlock) && !SimulinkConditionallyExecutedSubsystemCheck.isOtherTriggeredSubsystem(subBlock)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTriggeredFunctionCallSubsystem(SimulinkBlock subBlock) {
        return subBlock.isOfType("TriggerPort") && "function-call".equals(subBlock.getParameter("TriggerType")) && !"periodic".equals(subBlock.getParameter("SampleTimeType"));
    }

    private static boolean isOtherTriggeredSubsystem(SimulinkBlock subBlock) {
        String triggerType = subBlock.getParameter("TriggerType");
        return subBlock.isOfType("TriggerPort") && ("rising".equals(triggerType) || "falling".equals(triggerType) || "either".equals(triggerType));
    }
}

