/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0651", languages={ELanguage.SIMULINK})
public class SimulinkTypeConversionCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "The output data type is explicitly specified";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Use a Data Type Conversion block to specify the data type of the block output signal.");
    private static final Set<String> TYPES_WITHOUT_INHERITANCE_RULES = Set.of("EnablePort", "ForIterator");
    @CheckOption(name="Ignored block types", description="The given block types are ignored by this check. The types have to be specified in a comma-separated list. See [Configuring Simulink Block Types](./documentation/howto/improving-analysis-results-for-simulink/#configuring-block-types-in-simulink-analyses).")
    private static Set<String> ignoredBlockTypes = new HashSet<String>();
    @CheckOption(name="Ignore bus data types", description="When bus data types are ignored, no findings will be generated for blocks that receive or output a bus signal.")
    private static boolean ignoreBuses = false;

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (SimulinkTypeConversionCheck.isIgnoredBlockType(block) || SimulinkTypeConversionCheck.isPort(block) && SimulinkTypeConversionCheck.isOnRootLevel(block)) continue;
            this.checkForExplicitDataType(block);
            if (ignoreBuses) continue;
            this.checkForPortsUsingBuses(block);
        }
    }

    private static boolean isIgnoredBlockType(SimulinkBlock block) {
        return block.isOfType("DataTypeConversion") || TYPES_WITHOUT_INHERITANCE_RULES.contains(block.getType()) || ignoredBlockTypes.contains(block.getType()) || block.getSourceType() != null && ignoredBlockTypes.contains(block.getSourceType());
    }

    private void checkForExplicitDataType(SimulinkBlock block) {
        String outputDataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (outputDataType != null && !outputDataType.startsWith("Inherit: ") && !outputDataType.startsWith("Bus: ")) {
            this.context.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkForPortsUsingBuses(SimulinkBlock block) {
        if (!SimulinkTypeConversionCheck.isPort(block)) {
            return;
        }
        String outputDataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
        if (outputDataType != null && outputDataType.startsWith("Bus: ")) {
            this.context.buildFinding(FINDING_MESSAGE, (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean isPort(SimulinkBlock block) {
        return SimulinkUtils.isOutport((SimulinkBlock)block) || SimulinkUtils.isInport((SimulinkBlock)block);
    }

    private static boolean isOnRootLevel(SimulinkBlock block) {
        return block.getParent().equals(block.getModel());
    }
}

