/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.simulink.simulink.phases.ReferencedItem;
import java.io.Serializable;
import java.util.Objects;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class SimulinkFileReference
implements IExtractedValue<String>,
Serializable {
    private final String uniformPath;
    private final @Nullable String sourceBlockQualifiedName;
    private final ReferencedItem value;

    public static SimulinkFileReference modelFile(String uniformPath, String sourceBlockQualifiedName, String targetSimpleFileName) {
        return new SimulinkFileReference(uniformPath, sourceBlockQualifiedName, new ReferencedItem(ReferencedItem.EReferencedItemType.MODEL_FILE, targetSimpleFileName));
    }

    public static SimulinkFileReference libraryBlock(String uniformPath, String sourceBlockQualifiedName, String targetBlockQualifiedName) {
        return new SimulinkFileReference(uniformPath, sourceBlockQualifiedName, new ReferencedItem(ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY, targetBlockQualifiedName));
    }

    public static SimulinkFileReference modelSimpleFile(String uniformPath, String targetBlockQualifiedName) {
        return new SimulinkFileReference(uniformPath, null, new ReferencedItem(ReferencedItem.EReferencedItemType.MODEL_SIMPLE_FILE_NAME, targetBlockQualifiedName));
    }

    public static SimulinkFileReference dataDictionary(String uniformPath, String targetBlockQualifiedName) {
        return new SimulinkFileReference(uniformPath, null, new ReferencedItem(ReferencedItem.EReferencedItemType.DATA_DICTIONARY, targetBlockQualifiedName));
    }

    public static SimulinkFileReference dictionarySimpleFile(String uniformPath, String targetBlockQualifiedName) {
        return new SimulinkFileReference(uniformPath, null, new ReferencedItem(ReferencedItem.EReferencedItemType.DICTIONARY_SIMPLE_FILE_NAME, targetBlockQualifiedName));
    }

    public static SimulinkFileReference reference(String uniformPath, String sourceBlockQualifiedName, ReferencedItem.EReferencedItemType type, String targetBlockQualifiedName) {
        return new SimulinkFileReference(uniformPath, sourceBlockQualifiedName, new ReferencedItem(type, targetBlockQualifiedName));
    }

    public static SimulinkFileReference reference(String uniformPath, ReferencedItem referencedItem) {
        return new SimulinkFileReference(uniformPath, null, referencedItem);
    }

    private SimulinkFileReference(String uniformPath, @Nullable String refBlockQualifiedName, ReferencedItem value) {
        this.uniformPath = Objects.requireNonNull(uniformPath);
        this.sourceBlockQualifiedName = refBlockQualifiedName;
        this.value = value;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public String getValue() {
        return this.value.toStorageString();
    }

    public String getAdditionalInformation() {
        return "";
    }

    public ReferencedItem getReferenceItem() {
        return this.value;
    }

    public @Nullable String getSourceBlockQualifiedName() {
        return this.sourceBlockQualifiedName;
    }

    public boolean hasSourceWithParentBlockName(@Nullable String qualifiedNameOfParentBlock) {
        if (qualifiedNameOfParentBlock == null || this.sourceBlockQualifiedName == null) {
            return false;
        }
        String sourceBlockParentName = StringUtils.removeLastPart((String)this.sourceBlockQualifiedName, (char)'/');
        return sourceBlockParentName.equals(qualifiedNameOfParentBlock);
    }

    public boolean hasTargetWithType(ReferencedItem.EReferencedItemType type) {
        return this.value.getType() == type;
    }

    public boolean hasTargetWithName(String targetName) {
        return this.value.getTarget().equals(targetName);
    }

    public String toString() {
        if (this.sourceBlockQualifiedName != null) {
            return this.uniformPath + "(" + this.sourceBlockQualifiedName + ") > " + this.value.toStorageString();
        }
        return this.uniformPath + " > " + this.value.toStorageString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SimulinkFileReference otherItem = (SimulinkFileReference)other;
        return Objects.equals(this.uniformPath, otherItem.uniformPath) && Objects.equals(this.sourceBlockQualifiedName, otherItem.sourceBlockQualifiedName) && Objects.equals(this.value, otherItem.value);
    }

    public int hashCode() {
        return Objects.hash(this.uniformPath, this.sourceBlockQualifiedName, this.value);
    }
}

