/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.service.framework.IServiceProfiler;
import com.teamscale.service.framework.impl.cache.CacheControlUtils;
import jakarta.annotation.Priority;
import jakarta.inject.Provider;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Priority(value=3000)
public class CacheControlFilter
implements ContainerResponseFilter {
    public static final String ETAG_PROPERTY = "etag";
    public static final String CACHE_CONTROL_PROPERTY = "cache-control";
    private final CacheControl cacheControl;
    @Context
    private Provider<IServiceProfiler> serviceProfiler;

    public CacheControlFilter(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (((IServiceProfiler)this.serviceProfiler.get()).isEnabled()) {
            responseContext.getHeaders().putSingle((Object)"Cache-Control", (Object)CacheControlUtils.initNoCacheControl());
        }
        if (responseContext.getStatus() == Response.Status.OK.getStatusCode()) {
            responseContext.getHeaders().putSingle((Object)"Cache-Control", (Object)this.cacheControl);
        }
        if (requestContext.getProperty(CACHE_CONTROL_PROPERTY) != null) {
            responseContext.getHeaders().putSingle((Object)"Cache-Control", requestContext.getProperty(CACHE_CONTROL_PROPERTY));
        }
        if (requestContext.getProperty(ETAG_PROPERTY) != null) {
            responseContext.getHeaders().putSingle((Object)"ETag", requestContext.getProperty(ETAG_PROPERTY));
        }
    }
}

