/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.logging;

import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.service.ShortServiceLog;
import com.teamscale.core.utils.HttpRequestUtils;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.impl.error.ExceptionMapperBase;
import com.teamscale.service.framework.impl.logging.CriticalEventLogger;
import com.teamscale.service.framework.impl.logging.IRecordingLoggerWrapper;
import com.teamscale.service.framework.impl.logging.ServiceLogHandlerUtils;
import com.teamscale.service.framework.impl.logging.ServiceLoggingRequestFilter;
import com.teamscale.service.framework.logging.IRequestInfo;
import jakarta.annotation.Priority;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;

@Provider
@Priority(value=2)
public class ServiceLoggingResponseFilter
implements ContainerResponseFilter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long LONG_REQUEST_WARNING_THRESHOLD_IN_SECONDS = Long.getLong("com.teamscale.long-request-warning-threshold-in-seconds", 60L);
    private static final Marker REST_API_REQUEST_END_MARKER = MarkerManager.getMarker((String)"RequestEnd");
    @Context
    private IStaticServiceContext staticServiceContext;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private IRecordingLoggerWrapper logger;
    @Context
    private IRequestInfo requestInfo;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext response) {
        String target = requestContext.getUriInfo().getPath();
        List<CriticalEventLogger.CriticalEvent> criticalEvents = this.getCriticalEvents(requestContext, response);
        long requestTimeInMilliseconds = this.requestInfo.timeSinceRequestStartInNanoseconds() / 1000000L;
        ServiceLoggingResponseFilter.writeServiceLog(target, requestContext, this.logger, criticalEvents, this.staticServiceContext, this.requestInfo, requestTimeInMilliseconds);
        ServiceLoggingResponseFilter.writeResponseLog(response, this.requestInfo, requestTimeInMilliseconds);
        ServiceLoggingResponseFilter.clearThreadContext();
    }

    private static void writeResponseLog(ContainerResponseContext response, IRequestInfo requestInfo, long requestTimeInMilliseconds) {
        Level logLevel;
        Object message;
        if (ExceptionMapperBase.ERROR_STATUS_FAMILIES.contains((Object)response.getStatusInfo().getFamily())) {
            message = "Failed response. See Teamscale service log for more details.";
            logLevel = Level.ERROR;
        } else if (requestTimeInMilliseconds > LONG_REQUEST_WARNING_THRESHOLD_IN_SECONDS * 1000L) {
            message = "Successful response took more than " + LONG_REQUEST_WARNING_THRESHOLD_IN_SECONDS + " seconds.";
            logLevel = Level.WARN;
        } else {
            message = "Successful response.";
            logLevel = Level.INFO;
        }
        Supplier[] supplierArray = new Supplier[9];
        supplierArray[0] = () -> ((IRequestInfo)requestInfo).httpMethod();
        supplierArray[1] = () -> ((IRequestInfo)requestInfo).requestUri();
        supplierArray[2] = () -> ((ContainerResponseContext)response).getStatus();
        supplierArray[3] = () -> ((IRequestInfo)requestInfo).requestId();
        supplierArray[4] = () -> ((IRequestInfo)requestInfo).username();
        supplierArray[5] = () -> ((IRequestInfo)requestInfo).ipAddress();
        supplierArray[6] = () -> ((IRequestInfo)requestInfo).userAgent();
        supplierArray[7] = () -> requestTimeInMilliseconds;
        supplierArray[8] = () -> ServiceLoggingResponseFilter.lambda$writeResponseLog$1((String)message);
        ServiceLoggingRequestFilter.REST_API_REQUEST_LOGGER.log(logLevel, REST_API_REQUEST_END_MARKER, "Response=\"{} {}\", Status=\"{}\", Request-ID=\"{}\", User=\"{}\", IP=\"{}\", User-Agent=\"{}\", Request-Time=\"{}ms\": {}", supplierArray);
    }

    private static InternalProjectId determineInternalProjectId(ContainerRequestContext requestContext, IStaticServiceContext staticServiceContext) {
        try {
            Optional project;
            IProjectId projectId = ServiceLogHandlerUtils.determineProject(requestContext);
            if (projectId != null && (project = staticServiceContext.getProjectIndex().tryResolveProject(projectId)).isPresent() && !((ProjectInfo)project.get()).isDeletingOrReanalyzing()) {
                return ((ProjectInfo)project.get()).getInternalId();
            }
            return null;
        }
        catch (NotFoundException | StorageException e) {
            LOGGER.error("Error determining internal project ID from target " + String.valueOf(requestContext.getUriInfo().getRequestUri()) + ": " + e.getMessage(), e);
            return null;
        }
    }

    private static void writeServiceLog(String target, ContainerRequestContext requestContext, IRecordingLoggerWrapper logger, List<CriticalEventLogger.CriticalEvent> criticalEvents, IStaticServiceContext staticServiceContext, IRequestInfo requestInfo, long requestTimeInMilliseconds) {
        int debugCount = logger.getMessageCount(ELogLevel.DEBUG);
        int infoCount = logger.getMessageCount(ELogLevel.INFO);
        int warningCount = logger.getMessageCount(ELogLevel.WARN);
        int errorCount = logger.getMessageCount(ELogLevel.ERROR);
        int fatalCount = logger.getMessageCount(ELogLevel.FATAL);
        long now = DateTimeUtils.millisNow();
        InternalProjectId projectId = ServiceLoggingResponseFilter.determineInternalProjectId(requestContext, staticServiceContext);
        ServiceLogHandlerUtils.writeInteractionLog(projectId, now, target, logger.getLog4jMessages(), staticServiceContext.getIndexLayer());
        String parameters = HttpRequestUtils.createParameterString((ContainerRequestContext)requestContext);
        String httpMethod = requestInfo.httpMethod() != null ? requestInfo.httpMethod().name() : null;
        LogCount logCount = new LogCount(debugCount, infoCount, warningCount, errorCount, fatalCount);
        ShortServiceLog shortServiceLog = new ShortServiceLog(LogEntryIdentifier.freshWithTimestamp((long)now), target, httpMethod, requestInfo.username(), parameters, logCount, projectId);
        DetailedServiceLog detailedServiceLog = null;
        if (logCount.warningAndHigher() > 0) {
            detailedServiceLog = new DetailedServiceLog(shortServiceLog.getId(), logger.getMessages(), requestInfo.requestId(), httpMethod, requestInfo.requestUri(), target, parameters, requestTimeInMilliseconds, requestInfo.username(), requestInfo.ipAddress(), requestInfo.userAgent());
        }
        for (CriticalEventLogger.CriticalEvent criticalEvent : criticalEvents) {
            ShortCriticalEventServiceLog shortCriticalEventLog = new ShortCriticalEventServiceLog(shortServiceLog, criticalEvent.message(), criticalEvent.projectId(), criticalEvent.rollbackId());
            ServiceLogHandlerUtils.writeCriticalEventLog(shortCriticalEventLog, detailedServiceLog, staticServiceContext.getIndexLayer(), criticalEvent.projectId());
        }
        ServiceLogHandlerUtils.writeServiceLog(shortServiceLog, detailedServiceLog, staticServiceContext.getServerConfiguration().getServiceLogLevel(), staticServiceContext.getIndexLayer(), (IProjectId)projectId);
    }

    private List<CriticalEventLogger.CriticalEvent> getCriticalEvents(ContainerRequestContext requestContext, ContainerResponseContext response) {
        if (this.resourceInfo.getResourceMethod() == null) {
            return Collections.emptyList();
        }
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            return Collections.emptyList();
        }
        return CriticalEventLogger.getCriticalEvents(requestContext);
    }

    private static void clearThreadContext() {
        ThreadContext.remove((String)"requestUUID");
        ThreadContext.remove((String)"username");
        ThreadContext.remove((String)"ip");
    }

    private static /* synthetic */ Object lambda$writeResponseLog$1(String message) {
        return message;
    }
}

