/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.service.framework.impl.util.JerseyParameterNameProvider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;

@Provider
public class CaseInsensitiveEnumParamConverterProvider
implements ParamConverterProvider {
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!rawType.isEnum()) {
            return null;
        }
        Class<T> type = rawType;
        Enum[] constants = (Enum[])type.getEnumConstants();
        String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations);
        return new CaseInsensitiveEnumParamConverter<T>(rawType, constants, parameterName);
    }

    public static class CaseInsensitiveEnumParamConverter<T extends Enum<T>>
    implements ParamConverter<T> {
        private final Class<T> rawType;
        private final Enum<T>[] constants;
        private final String parameterName;

        private CaseInsensitiveEnumParamConverter(Class<T> rawType, Enum<T>[] constants, String parameterName) {
            this.rawType = rawType;
            this.constants = constants;
            this.parameterName = parameterName;
        }

        public T fromString(String value) {
            if (StringUtils.isEmpty((String)value)) {
                return null;
            }
            Enum constant = EnumUtils.valueOfIgnoreCase(this.rawType, (String)value);
            if (constant != null) {
                return (T)constant;
            }
            Enum constantWithUnderscoresInsteadDashes = EnumUtils.valueOfIgnoreCase(this.rawType, (String)value.replace("-", "_"));
            if (constantWithUnderscoresInsteadDashes != null) {
                return (T)constantWithUnderscoresInsteadDashes;
            }
            String constantsList = Arrays.stream(this.constants).map(Enum::toString).collect(Collectors.joining(", "));
            String errMsg = String.format("%s must be one of [%s], but was %s", this.parameterName, constantsList, value);
            throw new BadRequestException(errMsg);
        }

        public String toString(T value) {
            return ((Enum)value).toString();
        }
    }
}

