It is rather easy to completely publish a CDS view with OData Service.
When adding a `@OData.publish: true` annotation, this will create an OData Service.
If that service is also registered within SAP system via GUI interface, then the CDS view can be accessed from within or outside the SAP environment.

# How Can I Resolve This?
Instead of publishing with `OData.publish`, a service definition and bindings in combination with proper access controls should be used.


## Example (Non-Compliant)
```
@AbapCatalog-sqlViewName: 'ZCDSDMBSCVIEW"
@AbapCatalog.compiler.compareFilter: true
@AbapCatalog• preserveKey: true
@EndUserText. label: 'Documentation Text'
@OData.publish: true
define view entity Z_DEMO_BasicView as select from flight
{
    key carrid,
    key connid,
    key fldate,
        price,
        planetype
}
    where ( carrid = 'AA' ) and ( connid >= '0010' and connid <= '0064' ) and (price › 100 and price ＜ 1000)
```

## Example (Compliant)
```
@AbapCatalog-sqlViewName: 'ZCDSDMBSCVIEW"
@AbapCatalog.compiler.compareFilter: true
@AbapCatalog• preserveKey: true
@AccessControl.authorizationCheck: #CHECK
@EndUserText. label: 'Documentation Text'
define view entity Z_DEMO_BasicView as select from flight
{
    key carrid,
    key connid,
    key fldate,
        price,
        planetype
}
    where ( carrid = 'AA' ) and ( connid >= '0010' and connid <= '0064' ) and (price › 100 and price ＜ 1000)
```

```
@EndUserText.label: 'Documentation Text'
define service Z_SERVICE_DEFINITION {
  expose Z_DEMO_BasicView;
}
```

```
@EndUserText.label: 'ACL for Documentation Text'
@MappingRole: true
define role z_demo_basic_view {
    grant
        select
            on
                Z_DEMO_BasicView
                    where 
                    ( carrid ) = aspect pfcg_auth ( C_CARRID, carrid, actvt = '03' );
  }
```

## Where can I Learn More?
[Tutorial on how to create service definition and service binding](https://developers.sap.com/tutorials/abap-dev-create-cds-view.html)