This check detects modifications that were made to SAP standard code.

# Why is This a Problem?
SAP does not offer support for modifications to SAP standard objects. In case of issues, customers might need to reset those to standard.
Moreover, modifications have a high chance of needing to be adapted by the customer during each support package upgrade, increasing maintenance costs.

# Exceptions
Modifications might be necessary for specific processes requirements that cannot be achieved via different mechanisms.

# How can I resolve this?
It is recommended to consider other SAP enhancement options depending on the business requirements and potential subsequent costs:
- Customizing
- Personalization
- Enhancements (user exits, customer exits, enhancement points, enhancement sections)
- Business Add-Ins (BAdI)
- CDS extensions

# Where can I learn more?

## References
- [SAP Help Portal: Changing the SAP Standard](https://help.sap.com/docs/ABAP_PLATFORM_NEW/2b28ffa716c24348903f8ffbfeb81df8/c81975ad43b111d1896f0000e8322d00.html?locale=en-US)
- [DSAG Recommendations for ABAP Development, Section 8.4: Adaptation of SAP Functionality](https://dsag.de/wp-content/uploads/2021/12/dsag_recommendation_abap_development.pdf)