Unnecessary explicit calls to parameterless super constructors can clutter the code and decrease its readability. It's better to omit these explicit calls since they are implicitly made by the Java compiler.

# What Does This Check Look For?

This check reports a finding when a constructor explicitly calls a super constructor that takes no arguments.

# Why is This a Problem?

Explicitly calling a parameterless super constructor is redundant since the Java compiler automatically inserts this call if it's not present. Including it unnecessarily can lead to less readable and more verbose code, which can impede comprehension and maintenance. Reducing unnecessary verbosity in code is key to improving its readability and maintainability.

# How Can I Resolve This?

Consider removing the explicit call to the parameterless super constructor. This action streamlines the code and leverages the Java compiler's automatic insertion of such a call, thereby enhancing code clarity and conciseness.