

This blacklist data checks for a number of Python calls known to have possible
security implications. The following blacklist tests are run against any
function calls encountered in the scanned code base, triggered by encountering
ast.Call nodes.

------------

Standard pseudo-random generators are not suitable for security/cryptographic
purposes. Consider using the secrets module instead:
https://docs.python.org/library/secrets.html

| ID   |  Name               |  Calls                             |  Severity |
|------|---------------------|------------------------------------|-----------|
| B311 | random              | - random.Random                    | Low       |
|      |                     | - random.random                    |           |
|      |                     | - random.randrange                 |           |
|      |                     | - random.randint                   |           |
|      |                     | - random.choice                    |           |
|      |                     | - random.choices                   |           |
|      |                     | - random.uniform                   |           |
|      |                     | - random.triangular                |           |
|      |                     | - random.randbytes                 |           |

