# Rule 16.6 Every *switch* statement shall have at least two *switch-clauses*

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
A *switch* statement with a single path is redundant and may be indicative of a programming error.

## Example
```c
switch ( x )
{
 default: /* Non-compliant - switch is redundant */
 x = 0;
 break;
}
switch ( y )
{
 case 1:
 default: /* Non-compliant - switch is redundant */
 y = 0;
 break;
}
switch ( z )
{
 case 1:
 z = 2;
 break;
 default: /* Compliant */
 z = 0;
 break;
}
```

## See also
Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
