# Rule 21.12 The exception handling features of `<fenv.h>` should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C99

## Amplification
The identifiers *feclearexcept*, *fegetexceptflag*, *feraiseexcept*, *fesetexceptflag* and *fetestexcept* shall not be
used and no macro with one of these names shall be expanded.

The macros *FE_INEXACT*, *FE_DIVBYZERO*, *FE_UNDERFLOW*, *FE_OVERFLOW*, *FE_INVALID* and *FE_ALL_EXCEPT*,
along with any implementation-defined floating-point exception macros, shall not be used.

## Rationale
In some circumstances, the values of the floating-point status flags are unspecified and attempts to
access them may lead to undefined behaviour.

The order in which exceptions are raised by the *feraiseexcept* function is unspecified and could
therefore result in a program that has been designed for a certain order not operating correctly.

## Example
```c
#include <fenv.h>
void f ( float32_t x, float32_t y )
{
 float32_t z;
 feclearexcept ( FE_DIVBYZERO ); /* Non-compliant */
 z = x / y;
 if ( fetestexcept ( FE_DIVBYZERO ) ) /* Non-compliant */
 {
 }
 else
 {
#pragma STDC FENV_ACCESS ON
 z = x * y;
 }
 if ( z > x )
 {
#pragma STDC FENV_ACCESS OFF
 if ( fetestexcept ( FE_OVERFLOW ) ) /* Non-compliant */
 {
 }
 }
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
