# Rule 9.1 The value of an object with automatic storage duration shall not be read before it has been set

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99

## Amplification
For the purposes of this rule, an array element or structure member shall be considered as a discrete object.

## Rationale
According to The Standard, objects with static storage duration are automatically initialized to zero unless initialized explicitly. Objects with automatic storage duration are not automatically initialized and can therefore have indeterminate values.

Note: it is sometimes possible for the explicit initialization of an automatic object to be ignored. This will happen when a jump to a label using a *goto* or *switch* statement “bypasses” the declaration of the object; the object will be declared as expected but any explicit initialization will be ignored.

## Example
```c
void f ( bool_t b, uint16_t *p )
{
  if ( b )
  {
    *p = 3U;
  }
}

void g ( void )
{
  uint16_t u;

  f ( false, &u );
  if ( u == 3U )
  {
    /* Non-compliant - u has not been assigned a value */
  }
}
```

In the following non-compliant C99 example, the *goto* statement jumps past the initialization of x.

Note: This example is also non-compliant with Rule 15.1.

```c
{
  goto L1;
  uint16_t x = 10u;
L1:
  x = x + 1u; /* Non-compliant - x has not been assigned a value */
}
```

## See also
Rule 15.1, Rule 15.3

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
