# Rule 14.2 A for loop shall be well-formed
## Category
Required
## Analysis
Undecidable, System
## Applies to
C90, C99, C11
## Amplification
The three clauses of a *for* statement are the:
*First clause* which
- Shall be empty, or
- Shall be an expression whose only *persistent side effect* is to set the value of the *loop counter*, or
- Shall define and initialize the *loop counter* (C99 and later).
*Second clause* which
- Shall be an expression that has no *persistent side effects*, and
- Shall use the *loop counter* and optionally *loop control flags*, and
- Shall not use any other object that is modified in the *for* loop body.
*Third clause* which
- Shall be an expression whose only *persistent side effect* is to modify the value of the *loop counter*, and
- Shall not use objects that are modified in the *for* loop body.
There shall only be one *loop counter* in a *for* loop, which shall not be modified in the *for* loop body.
A *loop control flag* is defined as a single identifier denoting an object with *essentially Boolean type* that is used in the second clause.
The behaviour of a *for* loop body includes the behaviour of any functions called within that statement.
## Rationale
The *for* statement provides a general-purpose looping facility. Using a restricted form of loop makes code easier to review and to analyse.
## Exception
All three clauses may be empty, for example `for ( ; ; )`, so as to allow for infinite loops.
## Example
```c
/* In the following example, i is the loop counter and flag is a loop control flag. */
bool_t flag = false;
for ( int16_t i = 0; ( i < 5 ) && !flag; i++ )
{
 if ( C )
 {
 flag = true; /* Compliant - allows early termination
 * of loop */
 }
 i = i + 3; /* Non-compliant - altering the loop
 * counter */
}
```
## See also
Rule 14.1, Rule 14.3, Rule 14.4

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
