# Rule 21.26 The Standard Library function mtx_timedlock() shall only be invoked on mutex objects of appropriate mutex type
## Category
Required
## Analysis
Undecidable, System
## Applies to
C11
## Amplification
The first argument of the Standard Library function *mtx_timedlock()* shall be a mutex object of mutex type *mtx_timed* or `( mtx_timed | mtx_recursive )`.
## Rationale
Calling the function *mtx_timedlock()* on a mutex object that does not support timeout is undefined behaviour.
## Example
```c
mtx_t Ra;
mtx_t Rb;
mtx_t Rc;
struct timespec *ts;

void main( void )
{
 mtx_init( &Ra, mtx_plain );
 mtx_init( &Rb, mtx_timed );
 mtx_init( &Rc, mtx_timed | mtx_recursive );
 ...
}

int32_t t1( void* ignore )
{
 ...
 mtx_timedlock( &Ra, ts ); /* Non-compliant */
 mtx_timedlock( &Rb, ts ); /* Compliant */
 mtx_timedlock( &Rc, ts ); /* Compliant */
 ...
}
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
