# Dir 5.2 There shall be no deadlocks between threads 

## Category

Required 

## Applies to

C11 

## Amplification

A deadlock occurs when there is a circular chain of threads, each of which holding a locked synchronization resource, and trying to lock a synchronization resource held by the next element in the chain. To prevent deadlocks, synchronization mechanisms between threads shall not introduce cyclic dependencies. 

## Rationale

An example for a deadlock between two threads T1 and T2 is when T1 enters the waiting state because it requests a mutex Ra which is locked by thread T2, and T2 in turn is waiting for another mutex Rb held by thread T1. 

Possible solutions to avoid deadlocks include locking and unlocking synchronization resources in a fixed global non-cyclic order, or associating synchronization resources with appropriate priorities. 

## Example

Assume that in the following example functions t1 and t2 are executed as concurrent threads T1 and T2. Thread T1 locks mutex Ra, then executes some other code in which it might be interrupted by thread T2. Thread T2 locks mutex Rb, executes some other code, and is blocked when attempting to lock mutex Ra, which is currently held by thread T1. Hence thread T1 resumes, and eventually reaches the call to mtx_lock (&Rb) on which it blocks, because Rb is held by T2. Then execution is stuck indefinitely because thread T1 is waiting for thread T2 and vice versa. 

```c
mtx_t Ra;
mtx_t Rb;

int32_t t1 (void *ignore) /* Thread T1 entry */
{
    mtx_lock(&Ra);
    /* ... */
    mtx_lock(&Rb); /* Deadlock may occur here */
    mtx_unlock(&Rb);
    mtx_unlock(&Ra);
    return 0;
}

int32_t t2 (void *ignore) /* Thread T2 entry */
{
    mtx_lock(&Rb);
    /* ... */
    mtx_lock(&Ra); /* Deadlock may occur here */
    mtx_unlock(&Ra);
    mtx_unlock(&Rb);
    return 0;
}

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
