# Rule 17.13 A *function type* shall not be type qualified

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
The type qualifiers are *const*, *volatile*, *restrict* or *_Atomic*.

## Rationale
The behaviour is undefined if the specification of a *function type* includes any type qualifiers.

*Note:* this rule applies to a *function type* and not to the return type of a function.

## Example
```c
const uint16_t   cf (void);   /* Compliant - returns const uint16_t */
const uint16_t * pcf (void);  /* Compliant - returns a pointer to
                                             const uint16_t */
```
In the following examples, `ftype` is the type of a function returning `uint16_t`:
```c
typedef uint16_t ftype (void);

typedef const ftype cftype;           /* Non-compliant - cftype is const-qualified */
typedef ftype       dftype;           /* Compliant - dftype is not qualified       */
typedef ftype * const pcftype;        /* Compliant - const pointer to ftype        */

typedef const uint16_t * cfptype (void); /* Compliant - cfptype is the type of a
                                                        function returning
                                                        const uint16_t * */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].