# Rule 7.6 The small integer variants of the minimum-width integer constant macros shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Amplification
The minimum-width integer constant macros are of the form `INTn_C(value)` and `UINTn_C(value)`, where *n* is a value corresponding to a type `int_leastn_t`.

*Small integer* refers to any integer type with width less than that of type *int*.

## Rationale
The C Standard requires that the minimum-width integer constant macros expand to an integer constant expression suitable for use in *#if* pre-processing directive, and that the type of the expression has the same type as would result from integer promotion. Consequentially many implementations of the small integer macros have opted to simply substitute the macro for the argument. This results in an expression with type *int* and not the type that may have been anticipated by the use of the macro.

## Example
```c
int main( void )
{
  uint8_t a = UINT8_C( 100 ); /* Non-compliant - typically expands as plain 100 
                                 i.e. as a signed int */
}
```

The following example shows the impact of the typing conflict:

```c
#define M(x) _Generic( (x), uint8_t: fu8, default: fi )(x)

int main( void )
{
  M( UINT8_C( 100 ) ); /* Non-compliant - selects fi, not fu8 */
}
```

## See also
Rule 7.5

---

Copyright The MISRA Consortium Limited © [Date - March 2025].