# Rule 0–1–10 (Required) Every defined function shall be called at least once.

## Rationale
Functions or procedures that are not called may be symptomatic of a serious problem, such as missing paths.
Note that an unused prototype is not a violation of this rule.
See Section 3.5 for associated library issues.

## Example
```c
void f1 ( ) 
{ 
}
void f2 ( ) // Non-compliant 
{ 
}
void f3 ( ); // Compliant prototype
int32_t main ( ) 
{ 
 f1 ( );
 return ( 0 ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
