# Rule 0–1–3 (Required) A project shall not contain unused variables.

## Rationale
Variables declared and never used in a project constitute noise and may indicate that the wrong variable name has been used somewhere. Removing these declarations reduces the possibility that they may later be used instead of the correct variable.
If padding is used within bit-fields, then the padding member should be unnamed to avoid violation of this rule.

## Example
```c
extern void usefn ( int16_t a, int16_t b );
class C 
{ 
 ... 
};
C c; // Non-compliant - unused
void withunusedvar ( void ) 
{ 
 int16_t unusedvar; // Non-compliant – unused
 struct s_tag 
 { 
 signed int a : 3; 
 signed int pad : 1; // Non-compliant – should be unnamed 
 signed int b : 2; 
 } s_var;
 s_var.a = 0; 
 s_var.b = 0; 
 usefn ( s_var.a, s_var.b ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
