# Rule 15–1–2 (Required) NULL shall not be thrown explicitly.

## Rationale
throw(NULL) (equivalent to throw(0)) is never a throw of the null-pointer-constant and so is only ever caught by an integer handler. This may be inconsistent with developer expectations, particularly if the program only has handlers for pointer-to-type exceptions.

## Example
```c
try 
{ 
 throw ( NULL ); // Non-compliant 
}
catch ( int32_t i ) // NULL exception handled here 
{ 
 // ... 
}
catch ( const char_t * ) // Developer may expect it to be caught here 
{ 
 // ... 
}
char_t * p = NULL; 
try 
{ 
 throw ( static_cast < const char_t * > ( NULL ) ); // Compliant, 
 // but breaks 
 // Rule 15–0–2 
 throw ( p ); // Compliant 
}
catch ( int32_t i ) 
{ 
 // ... 
}
catch ( const char_t * ) // Both exceptions handled here 
{ 
 // ... 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
