# Rule 3–1–2 (Required) Functions shall not be declared at block scope.

## Rationale
A function declared at block scope will refer to a member of the enclosing namespace, and so the declaration should be explicitly placed at the namespace level.
Additionally, where a declaration statement could either declare a function or an object, the compiler will choose to declare the function. To avoid potential developer confusion over the meaning of a declaration, functions should not be declared at block scope.

## Example
```c
class A 
{ 
};
void b1 ( ) 
{ 
 void f1 (); // Non-compliant - declaring a function in block scope 
 A a (); // Non-compliant - appears to declare an object with no 
 // arguments to constructor, but it too declares a 
 // function 'a' returning type 'A' and taking no 
 // parameters. 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
