# Rule 5–17–1 (Required) The semantic equivalence between a binary operator and its assignment operator form shall be preserved.

## Rationale
Where a set of operators is overloaded, it is important that the interactions between the operators meet developer expectations.

## Example
```c
class A 
{ 
public: 
 A& operator= ( A const & rhs ); 
};
A & operator += ( A const & lhs, A const & rhs ); 
A const operator + ( A const & lhs, A const & rhs );
void f ( A a1, A a2 ) 
{ 
 A x; 
 x = a1 + a2; // Example 1 
 a1 += a2; // Example 2
 if ( x == a1 ) // Example 3 
 { 
 } 
}
```
For a built-in type, the results of Example 1 and Example 2 will be the same, therefore the condition in Example 3 should always be true. This should also be true for overloaded versions of these operators.

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
