# Rule 6–4–5 (Required) An unconditional throw or break statement shall terminate every non‑empty switch-clause.

## Rationale
If a developer fails to add a break statement to the end of a switch-clause, then control flow “falls” into any following switch-clause. Whilst this is sometimes intentional, it is often an error.
To ensure that such errors can be detected, the last statement in every switch-clause shall be a break statement, or if the switch-clause is a compound statement, then the last statement in the compound statement shall be a break statement.
A special case exists if the switch-clause is empty, as this allows groups of clauses requiring identical statements to be created.

## Example
```c
switch ( x ) 
{ 
case 0: 
 break; // Compliant 
case 1: // Compliant - empty drop through 
case 2: // allows a group 
 break; // Compliant 
case 3: 
 throw; // Compliant 
case 4: 
 a = b; 
 // Non-compliant - non empty drop through 
default: 
 ; // Non-compliant – default must also have "break" 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
