# Rule 19.2.1 Precautions shall be taken in order to prevent the contents of a header file being included more than once

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
In order to facilitate checking, the contents of the *header file* shall be protected from being included
more than once using one of the following two forms of include guard:

```cpp
<start-of-file>
#if !defined ( IDENTIFIER )
#define IDENTIFIER
 // Contents of file
#endif
<end-of-file>
```

```cpp
<start-of-file>
#ifndef IDENTIFIER
#define IDENTIFIER
 // Contents of file
#endif
<end-of-file>
```

*Notes:*
1. The identifier used to test and record whether a given *header file* has already been included
shall be unique across all the *header files* included within the *translation unit*;
2. Comments are permitted anywhere within these forms.

## Rationale
When a *translation unit* contains a complex hierarchy of nested *header files*, it is possible for a particular
*header file* to be included more than once. This can be, at best, a source of confusion. If this multiple
inclusion leads to multiple or conflicting definitions, then this can result in erroneous or *undefined
behaviour*.

*Note:* implementations may provide other mechanisms to prevent multiple inclusion — for example
`#pragma once` (use of which is restricted by Rule 19.6.1). However, their use is not permitted as they
are not specified within the C++ Standard.

## Example
```cpp
// file.h
#ifndef FILE_H // Non-compliant - no include guard in this file
#define FILEH // <-- this does not #define FILE_H
#endif
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
