# Rule 26.3.1 std::vector should not be specialized with bool

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Rationale
The `std::vector< bool >` specialization's behaviour differs from that of other uses of `std::vector`
as it uses optimized space allocation. For example, the `data` member function is not available.

The C++ Standard guarantees that, in general, elements of a C++ Standard Library container can be
modified concurrently, but specifically notes that this is not true for `std::vector< bool >`.

*Note:* other C++ Standard Library containers do not have specializations for `bool` and do not exhibit
the behaviours identified above.

## Example
```cpp
struct myBool { bool b; }; // Wrapper for bool

void foo() noexcept
{
 std::vector< bool > a; // Non-compliant - optimized storage
 std::vector< std::uint8_t > b; // Compliant
 std::vector< myBool > c; // Compliant
 std::array < bool, 20 > d; // Rule does not apply
 std::bitset< 200 > e; // Rule does not apply - efficient storage
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
