# Rule 6.0.4 The identifier `main` shall not be used for a function other than the global function `main`

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule also applies to any other entry points defined by the implementation.

## Rationale
`main` (or its equivalent) is the entry point to the program and is the only identifier which must be in
the global namespace. The use of `main` for other functions may not meet developer expectations.

## Example
```cpp
int main() // Compliant
{
}

namespace
{
  int main() // Non-compliant
  {
  }
}

namespace NS
{
  int main() // Non-compliant
  {
  }
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
