# Rule 9.6.5 A function with non-void return type shall return a value on all paths

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
The *compound statement* of a lambda expression with a non-`void` return type is also considered to
be a function covered by this rule.

A `return` is not required after an explicit `throw` or after calling a function marked `[[noreturn]]`.

This rule does not apply to `main`, as it implicitly returns `0` if an exit path does not explicitly return a
value.

*Note:* flowing off the end of a function body, except within `main`, is equivalent to a `return` with no
operand.

## Rationale
The operand to `return` gives the value that the function returns. The absence of a `return` with an
operand in an execution path through a function with a non-`void` return type results in *undefined
behaviour*.

## Example
```cpp
int32_t fn1() // Non-compliant
{
 // No return
}

int32_t fn2( int32_t x ) // Compliant
{
 if ( x > 100 )
 {
 throw 42; // Exiting via an exception
 }
 else
 {
 return x; // Value returned on other path
 }
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
