# Dir 0.3.2 A function call shall not violate the function’s preconditions

## Category
Required

## Rationale
Violating a function’s implicit or explicit preconditions may lead to it exhibiting unexpected results or
having *undefined behaviour*.

## Example
```cpp
float f( float a )
{
  return fmodf( a, 0.0f ); // 'fmodf' requires a non zero value
}

// Precondition for 'b1' is that 'v' is not empty
int32_t b1( std::vector< int32_t > const & v )
{
  return v.front ();
}

int32_t b2()
{
  std::vector< int32_t > v;
  return b1( v ); // Violates the precondition of b1
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
