# Rule 20.2 The `'`, `"` or `\` characters and the `/*` or `//` character sequences shall not occur in a header file name

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
The behaviour is undefined if:
* The `'`, `"` or `\` characters, or the `/*` or `//` character sequences are used between `<` and `>`
delimiters in a header name preprocessing token;
* The `'` or `\` characters, or the `/*` or `//` character sequences are used between the `"` delimiters
in a header name preprocessing token.

*Note*: although use of the `\` character results in undefined behaviour, many implementations will
accept the `/` character in its place.

## Example
```c
#include "fi'le.h" /* Non-compliant */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
