# Rule 11.10 The _Atomic qualifier shall not be applied to the incomplete type void
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C11
## Rationale
The C Standard does not explicitly prohibit usage of the type *void* with the *_Atomic* qualifier. However, it does not provide a guarantee that a pointer to *_Atomic void* has any particular size or alignment requirement, so it cannot be assumed that is the same as for a pointer to an arbitrary type *_Atomic T*, and the behaviour of type conversion between them may be undefined.
## Example
```c
struct A {
 int32_t _Atomic x;
 int32_t _Atomic y;
};

void main (void)
{
 struct A a1 = { 6, 7 };
 
 void _Atomic * pav = &a1; /* Non-compliant */
 void _Atomic * pax = &a1.x; /* Non-compliant */
}
```
## See also
Rule 11.8

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
