# Rule 11.5 A conversion should not be performed from pointer to void into pointer to object
## Category
Advisory
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
Conversion of a pointer to *void* into a pointer to object may result in a pointer that is not correctly aligned, resulting in undefined behaviour. It should be avoided where possible but may be necessary, for example when dealing with memory allocation functions. If conversion from a pointer to object into a pointer to *void* is used, care should be taken to ensure that any pointers produced do not give rise to the undefined behaviour discussed under Rule 11.3.
## Exception
A *null pointer constant* that has type pointer to *void* may be converted into pointer to object.
## Example
```c
uint32_t *p32;
void *p;
uint16_t *p16;

p = p32; /* Compliant - pointer to uint32_t into
 * pointer to void */
p16 = p; /* Non-compliant */
p = ( void * ) p16; /* Compliant */
p32 = ( uint32_t * ) p; /* Non-compliant */
```
## See also
Rule 11.2, Rule 11.3

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
