# Rule 16.1 All switch statements shall be well-formed
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
A *switch* statement shall be considered to be well-formed if it conforms to the subset of C *switch* statements that is specified by the following syntax rules. If a syntax rule given here has the same name as one defined in the C Standard then it replaces the standard version for the scope of the *switch* statement; otherwise, all syntax rules given in the C Standard are unchanged.
*switch-statement:*
 `switch ( switch-expression ) { case-label-clause-list final-default-clause-list }`
 `switch ( switch-expression ) { initial-default-clause-list case-label-clause-list }`
*case-label-clause-list:*
 *case-clause-list*
 *case-label-clause-list case-clause-list*
*case-clause-list:*
 *case-label switch-clause*
 *case-label case-clause-list*
*case-label:*
 `case` *constant-expression:*
*final-default-clause-list:*
 `default:` *switch-clause*
 *case-label final-default-clause-list*
*initial-default-clause-list:*
 `default:` *switch-clause*
 `default:` *case-clause-list*
*switch-clause:*
 *statement-listopt* `break;`
 C90: `{` *declaration-listopt statement-listopt* `break; }`
 C99 and later: `{` *block-item-listopt* `break; }`
Except where explicitly permitted by this syntax, the `case` and `default` keywords may not appear anywhere within a *switch* statement body.
Note: some of the restrictions imposed on *switch* statements by this rule are expounded in the rules referenced in the “See also” section. It is therefore possible for code to violate both this rule and one of the more specific rules.
Note: the term *switch label* is used within the text of the specific *switch* statement rules to denote either a *case label* or a *default label*.
## Rationale
The syntax for the *switch* statement in C is not particularly rigorous and can allow complex, unstructured behaviour. This and other rules impose a simple and consistent structure on the *switch* statement.
## Example
The remaining rules in this section give examples that are also relevant to this rule.
## See also
Rule 15.3, Rule 16.2, Rule 16.3, Rule 16.4, Rule 16.5, Rule 16.6

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
