# Rule 17.8 A function parameter should not be modified
## Category
Advisory
## Analysis
Undecidable, System
## Applies to
C90, C99, C11
## Rationale
A function parameter behaves in the same manner as an object that has automatic storage duration. While the C language permits parameters to be modified, such use can be confusing and conflict with programmer expectations. It may be less confusing to copy the parameter to an automatic object and modify that copy. With a modern compiler, this will not usually result in any storage or execution time penalty.
Programmers who are unfamiliar with C, but who are used to other languages, may modify a parameter believing that the effects of the modification will be felt in the calling function.
## Example
```c
int16_t glob = 0;

void proc ( int16_t para )
{
 para = glob; /* Non-compliant */
}

void f ( char *p, char *q )
{
 p = q; /* Non-compliant */
 *p = *q; /* Compliant */
}
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
