# Rule 4.2 Trigraphs should not be used

## Category

Advisory

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Rationale

Trigraphs are denoted by a sequence of two question marks followed by a specified third character (e.g. `??-` represents a `~` (tilde) character and `??)` represents a `]`). They can cause accidental confusion with other uses of two question marks.

Note: the so-called digraphs `<:`, `:>`, `<%`, `%>`, `%:` and `%:%:` are permitted because they are tokens. Trigraphs are replaced wherever they appear in the program prior to preprocessing. 

## Example

For example the string:
`"(Date should be in the form ??-??-??)"`
would not behave as expected, actually being interpreted by the compiler as:
`"(Date should be in the form ~~])"`

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
