# Rule 11.11 Pointers shall not be implicitly compared to NULL

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
Expressions of pointer type shall not be implicitly compared to `NULL` (or zero).

Implicit comparison to `NULL` occurs when an expression of pointer type is:
*   converted to *bool*
*   used as the operand of logical operator ( `!`, `&&`, `||` )
*   used as the first operand of conditional operator ( `?` )
*   used as the controlling expression of an *if* statement or an iteration statement (*while*, *do*, *for*)

## Rationale
An expression of *essentially Boolean* type shall always be used where an operand is interpreted as a Boolean value.

## Example
```c
uint32_t *ptr;

(bool)( ptr != NULL );          /* Compliant */
(bool)( ptr );                  /* Non-compliant - implicit test for zero */
                                /* - this also violates R.11.4 */

if ( ptr != NULL ) { ... }      /* Compliant - explicit test for Null */
if ( ptr != 0 )    { ... }      /* Compliant - explicit test for zero */
                                /* - however, this violates R.11.9 */

if ( !ptr ) { ... }             /* Non-compliant - implicit test for zero */
if ( ptr && *ptr == 1 ) { ... } /* Non-compliant - implicit test for zero */

/* The following non-compliant example also violate Rule 14.4 */
if ( ptr ) { ... }              /* Non-compliant - implicit test for zero */
```

## See also
Rule 11.4, Rule 11.9, Rule 14.4,

---

Copyright The MISRA Consortium Limited © [Date - March 2025].