# Rule 2.1 A project shall not contain unreachable code

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Rationale
Provided that a program does not exhibit any undefined behaviour, *unreachable code* cannot be executed and cannot have any effect on the program’s outputs. The presence of *unreachable code* may therefore indicate an error in the program’s logic.

A compiler is permitted to remove any *unreachable code* although it does not have to do so. *Unreachable code* that is **not** removed by the compiler wastes resources, for example:
*   It occupies space in the target machine’s memory;
*   Its presence may cause a compiler to select longer, slower jump instructions when transferring control around the *unreachable code*;
*   Within a loop, it might prevent the entire loop from residing in an instruction cache.

It is sometimes desirable to insert code that appears to be unreachable in order to handle exceptional cases. For example, in a switch statement in which every possible value of the controlling expression is covered by an explicit *case*, a *default* clause shall be present according to Rule 16.4. The purpose of the *default* clause is to trap a value that should not normally occur but that may have been generated as a result of:
*   Undefined behaviour present in the program;
*   A failure of the processor hardware.

If a compiler can prove that a *default* clause is unreachable, it may remove it, thereby eliminating the defensive action. On the assumption that the defensive action is important, it will be necessary either to demonstrate that the compiler does not eliminate the code despite it being unreachable, or to take steps to make the defensive code reachable.

The former course of action requires a deviation against this rule, probably with a review of the object code or unit testing being used to support such a deviation.

The latter course of action can usually be achieved by means of a *volatile* access. For example, a compiler might determine that the range of values held by `x` is covered by the *case* clauses in a *switch* statement such as:

```c
uint16_t x;

switch ( x )
```

By forcing `x` to be accessed by means of a *volatile* qualified *lvalue*, the compiler has to assume that the controlling expression could take any value:

`switch ( *( volatile uint16_t * ) &x )`

Note: code that has been conditionally excluded by pre-processor directives is not subject to this rule as it is not presented to the later phases of translation.

## Example
```c
enum light { red, amber, red_amber, green };

enum light next_light ( enum light c )
{
  enum light res;

  switch ( c )
  {
    case red:
      res = red_amber;
      break;
    case red_amber:
      res = green;
      break;
    case green:
      res = amber;
      break;
    case amber:
      res = red;
      break;

    default:
    {
      /*
       * This default will only be reachable if the parameter c
       * holds a value that is not a member of enum light.
       */
      error_handler ( );
      break;
    }
  }
  return res;
  res = c;        /* Non-compliant - this statement is
                   * certainly unreachable             */
}
```

## See also
Rule 14.3, Rule 16.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].