# Rule 20.3 The *#include* directive shall be followed by either a `<filename>` or `"filename"` sequence

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
This rule applies after macro replacement has been performed.

## Rationale
The behaviour is undefined if a *#include* directive does not use one of the following forms:
*   `#include <filename>`
*   `#include "filename"`

## Example
```c
#include "filename.h"         /* Compliant     */
#include <filename.h>         /* Compliant     */
#include another.h            /* Non-compliant */

#define HEADER "filename.h"
#include HEADER               /* Compliant     */

#define FILENAME file2.h
#include FILENAME             /* Non-compliant */

#define BASE "base"
#define EXT ".ext"
#include BASE EXT             /* Non-compliant - strings are concatenated
                               * after preprocessing                      */

#include "./include/cpu.h"    /* Compliant - filename may include a path */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].