# Rule 21.17 Use of the string handling functions from `<string.h>` shall not result in accesses beyond the bounds of the objects referenced by their pointer parameters

## Category
Mandatory

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
The relevant string handling functions from `<string.h>` are:
`strcat`, `strchr`, `strcmp`, `strcoll`, `strcpy`, `strcspn`, `strlen`, `strpbrk`, `strrchr`, `strspn`, `strstr`, `strtok`

## Rationale
Incorrect use of a function listed above may result in a read or write access beyond the bounds of an object passed as a parameter, resulting in *undefined behaviour*.

## Example
```c
char string[] = "Short";

void f1 ( const char *str )
{
  /*
   * Non-compliant use of strcpy as it results in writes beyond the end of 'string'
   */
  ( void ) strcpy ( string, "Too long to fit" );

  /*
   * Compliant use of strcpy as 'string' is only modified if 'str' will fit.
   */
  if ( strlen ( str ) < ( sizeof ( string ) - 1u ) )
  {
    ( void ) strcpy ( string, str );
  }
}

size_t f2 ( void )
{
  char text[ 5 ] = "Token";

  /*
   * The following is non-compliant as it results in reads beyond
   * the end of 'text' as there is no null terminator.
   */
  return strlen ( text );
}
```

## See also
Rule 21.18

---

Copyright The MISRA Consortium Limited © [Date - March 2025].