# Rule 21.22 All operand arguments to any type-generic macros declared in `<tgmath.h>` shall have an appropriate *essential type*

## Category
Mandatory

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Amplification
The operand arguments passed to the type-generic macros defined in `<tgmath.h>` shall have *essentially signed*, *essentially unsigned* or *essentially floating* (either *essentially real floating* or *essentially complex floating*) type.

Arguments to the following macros shall not have *essentially complex floating* type:
`atan2`, `cbrt`, `ceil`, `copysign`, `erf`, `erfc`, `exp2`, `expm1`, `fdim`, `floor`, `fma`, `fmax`, `fmin`, `fmod`, `frexp`, `hypot`, `ilogb`, `ldexp`, `lgamma`, `llrint`, `llround`, `log10`, `log1p`, `log2`, `logb`, `lrint`, `lround`, `nearbyint`, `nextafter`, `nexttoward`, `remainder`, `remquo`, `rint`, `round`, `scalbn`, `scalbln`, `tgamma`, `trunc`.

*Note:* The final parameter to the *frexp* and *remquo* macros is for output, and is not considered an operand.

## Rationale
Arguments of non-arithmetic types are not convertible to any of the corresponding real types defined for the macros defined in `<tgmath.h>`. Attempting to use them therefore results in undefined behaviour.

Casting an argument with *essentially signed* or *essentially unsigned* type to an *essentially real floating* type is not required because the purpose of these macros is to be type-generic. The essential type of the parameter derives from the argument.

Passing an *essentially complex floating* argument to one of the macros listed in the amplification results in undefined behaviour.

## Example
Real-valued arguments must have *essentially signed* or *essentially unsigned* or *essentially floating* type:
```c
#include <tgmath.h> /* Non-compliant with Rule 21.11 */

float f1, f2;
int32_t i1, i2;

char c1, c2;
void *p1, *p2;

void fn1 (void)
{
  f2 = sqrt (f1); /* Compliant - essentially floating real type */
  i2 = sqrt (i1); /* Compliant - essentially integer real type */

  c2 = sqrt (c1); /* Non-compliant - essentially character real type */
  p2 = sqrt (p1); /* Non-compliant - undefined behaviour */
}
```
Arguments to the macros listed in the amplification must have a real type:
```c
  float f1, f2;
 _Complex float cf1, cf2;

void fn2 (void)
{
  f2 = sqrt ( f1); /* Compliant - real argument */
  cf2 = sqrt (cf1); /* Compliant - sqrt has a complex equivalent */

  f2 = ceil ( f1); /* Compliant - real argument */
  cf2 = ceil (cf1); /* Non-compliant - undefined behaviour */
}
```

## See also
Rule 21.11, Rule 21.23

---

Copyright The MISRA Consortium Limited © [Date - March 2025].