# Rule 22.8 The value of *errno* shall be set to zero prior to a call to an *errno-setting-function*

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99, C11

## Amplification
An *errno-setting-function* is one of the following:

`ftell`, `fgetpos`, `fsetpos`, `fgetwc`, `fputwc`
`strtoimax`, `strtoumax`, `strtol`, `strtoul`, `strtoll`, `strtoull`, `strtof`, `strtod`, `strtold`
`wcstoimax`, `wcstoumax`, `wcstol`, `wcstoul`, `wcstoll`, `wcstoull`, `wcstof`, `wcstod`, `wcstold`
`wcrtomb`, `wcsrtombs`, `mbrtowc`

Any other function which returns error information using *errno* is also an *errno-setting-function*.
*Note:* this may include additional functions from the Standard Library, as permitted by the C Standard.

“Prior” requires that *errno* shall be set to zero in the same function and on all paths leading to a call of an *errno-setting-function*. Furthermore, there shall be no calls to functions that may set *errno* in these paths. This includes calls to any function within the Standard Library as these are permitted (but not required) to set *errno*.

## Rationale
An *errno-setting-function* writes a non-zero value to *errno* if an error is detected, leaving the value unmodified otherwise. The C Standard includes non-normative advice that “a program that uses *errno* for error checking should set it to zero before a library function call, then inspect it before a subsequent library function call”.

In order that errors can be detected, this rule requires that *errno* shall be set to zero before an *errno-setting-function* is called. Rule 22.9 then requires that *errno* be tested after the call.

## Exception
The value of *errno* need not be set to zero when it can be proven to be zero.

## Example
```c
void f ( void )
{
  errnoSettingFunction1();      /* Non-compliant */

  if ( 0 == errno )
  {
    errnoSettingFunction2();    /* Compliant by exception */

    if ( 0 == errno )
    {
    }
  }

  else
  {
    errno = 0;

    errnoSettingFunction3();    /* Compliant     */

    if ( 0 == errno )
    {
    }
  }
}
```

## See also
Rule 22.9, Rule 22.10

---

Copyright The MISRA Consortium Limited © [Date - March 2025].